<?php

namespace Webkul\Inventory\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Webkul\Inventory\Enums\LocationType;
use Webkul\Security\Models\User;

class LocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::first();

        DB::table('inventories_rules')->delete();

        DB::table('inventories_operations')->delete();

        DB::table('inventories_product_quantities')->delete();

        DB::table('inventories_scraps')->delete();

        DB::table('inventories_moves')->delete();

        DB::table('inventories_move_lines')->delete();

        DB::table('inventories_operation_types')->delete();

        DB::table('inventories_warehouses')->delete();

        DB::table('inventories_routes')->delete();

        DB::table('inventories_locations')->delete();

        DB::table('inventories_locations')->insert([
            [
                'id'           => 1,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 0,
                'type'         => LocationType::VIEW,
                'name'         => 'Physical Locations',
                'full_name'    => 'Physical Locations',
                'barcode'      => null,
                'parent_path'  => '1/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => null,
                'creator_id'   => $user->id,
                'company_id'   => null,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 2,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 1,
                'type'         => LocationType::VIEW,
                'name'         => 'Partners',
                'full_name'    => 'Partners',
                'barcode'      => null,
                'parent_path'  => '2/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => null,
                'creator_id'   => $user->id,
                'company_id'   => null,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 3,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 1,
                'type'         => LocationType::VIEW,
                'name'         => 'Virtual Locations',
                'full_name'    => 'Virtual Locations',
                'barcode'      => null,
                'parent_path'  => '3/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => null,
                'creator_id'   => $user->id,
                'company_id'   => null,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 4,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 1,
                'type'         => LocationType::SUPPLIER,
                'name'         => 'Vendors',
                'full_name'    => 'Partners/Vendors',
                'barcode'      => null,
                'parent_path'  => '2/4/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 2,
                'creator_id'   => $user->id,
                'company_id'   => null,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 5,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 1,
                'type'         => LocationType::CUSTOMER,
                'name'         => 'Customers',
                'full_name'    => 'Partners/Customers',
                'barcode'      => null,
                'parent_path'  => '2/5/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 2,
                'creator_id'   => $user->id,
                'company_id'   => null,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 6,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 1,
                'type'         => LocationType::TRANSIT,
                'name'         => 'Inter Company Transit',
                'full_name'    => 'Virtual Locations/Inter Company Transit',
                'barcode'      => null,
                'parent_path'  => '3/6/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 3,
                'creator_id'   => $user->id,
                'company_id'   => null,
                'deleted_at'   => now(),
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 7,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 1,
                'type'         => LocationType::TRANSIT,
                'name'         => 'Inter Warehouse Transit',
                'full_name'    => 'Physical Locations/Inter Warehouse Transit',
                'barcode'      => null,
                'parent_path'  => '1/7/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 1,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => now(),
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 8,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 1,
                'type'         => LocationType::INVENTORY,
                'name'         => 'Inventory Adjustment',
                'full_name'    => 'Virtual Locations/Inventory Adjustment',
                'barcode'      => null,
                'parent_path'  => '3/8/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 3,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 9,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 1,
                'type'         => LocationType::PRODUCTION,
                'name'         => 'Production',
                'full_name'    => 'Virtual Locations/Production',
                'barcode'      => null,
                'parent_path'  => '3/9/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 3,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 10,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 1,
                'type'         => LocationType::INVENTORY,
                'name'         => 'Scrap',
                'full_name'    => 'Virtual Locations/Scrap',
                'barcode'      => null,
                'parent_path'  => '3/10/',
                'is_scrap'     => true,
                'is_replenish' => false,
                'parent_id'    => 3,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 11,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 0,
                'type'         => LocationType::VIEW,
                'name'         => 'WH',
                'full_name'    => 'WH',
                'barcode'      => null,
                'parent_path'  => '1/11/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 1,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 12,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 0,
                'type'         => LocationType::INTERNAL,
                'name'         => 'Stock',
                'full_name'    => 'WH/Stock',
                'barcode'      => 'WHSTOCK',
                'parent_path'  => '1/11/12/',
                'is_scrap'     => false,
                'is_replenish' => true,
                'parent_id'    => 11,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => null,
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 13,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 0,
                'type'         => LocationType::INTERNAL,
                'name'         => 'Input',
                'full_name'    => 'WH/Input',
                'barcode'      => 'WHINPUT',
                'parent_path'  => '1/11/13/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 11,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => now(),
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 14,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 0,
                'type'         => LocationType::INTERNAL,
                'name'         => 'Quality Control',
                'full_name'    => 'WH/Quality Control',
                'barcode'      => 'WHQUALITY',
                'parent_path'  => '1/11/14/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 11,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => now(),
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 15,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 0,
                'type'         => LocationType::INTERNAL,
                'name'         => 'Output',
                'full_name'    => 'WH/Output',
                'barcode'      => 'WHOUTPUT',
                'parent_path'  => '1/11/15/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 11,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => now(),
                'created_at'   => now(),
                'updated_at'   => now(),
            ], [
                'id'           => 16,
                'position_x'   => 0,
                'position_y'   => 0,
                'position_z'   => 0,
                'type'         => LocationType::INTERNAL,
                'name'         => 'Packing Zone',
                'full_name'    => 'WH/Packing Zone',
                'barcode'      => 'WHPACKING',
                'parent_path'  => '1/11/16/',
                'is_scrap'     => false,
                'is_replenish' => false,
                'parent_id'    => 11,
                'creator_id'   => $user->id,
                'company_id'   => $user->default_company_id,
                'deleted_at'   => now(),
                'created_at'   => now(),
                'updated_at'   => now(),
            ],
        ]);
    }
}
