<?php

return [
    'title' => 'Employees',

    'navigation' => [
        'title' => 'Employees',
        'group' => 'Employees',
    ],

    'global-search' => [
        'name'       => 'Employee Name',
        'department' => 'Department',
        'work-email' => 'Work Email',
        'work-phone' => 'Work Phone',
    ],

    'form' => [
        'sections' => [
            'fields' => [
                'name'          => 'Name',
                'job-title'     => 'Job Title',
                'work-email'    => 'Work Email',
                'work-phone'    => 'Work Phone',
                'department'    => 'Department',
                'work-mobile'   => 'Work Mobile',
                'job-position'  => 'Job Position',
                'manager'       => 'Manager',
                'coach'         => 'Coach',
                'employee-tags' => 'Employee Tags',
            ],
        ],

        'tabs' => [
            'work-information' => [
                'title' => 'Work Information',

                'fields' => [
                    'location'             => 'Location',
                    'work-address'         => 'Work Address',
                    'work-location'        => 'Work Location',
                    'approver'             => 'Approver',
                    'time-off'             => 'Time Off',
                    'attendance-manager'   => 'Attendance Manager',
                    'schedule'             => 'Schedule',
                    'working-hours'        => 'Working Hours',
                    'time-zone'            => 'Time Zone',
                    'time-zone-tooltip'    => 'Specify the time zone for this work schedule',
                    'organization-details' => 'Organization Details',
                    'company'              => 'Company',
                    'color'                => 'Color',
                ],
            ],

            'private-information' => [
                'title' => 'Private Information',

                'fields' => [
                    'country'                     => 'Country',
                    'country-name'                => 'Country Name',
                    'country-code'                => 'Country Code',
                    'country-state-required'      => 'State Required',
                    'country-zip-required'        => 'Zipcode Required',
                    'create-country'              => 'Create Country',
                    'state'                       => 'State',
                    'state-name'                  => 'Name',
                    'state-code'                  => 'Code',
                    'state-country'               => 'Country',
                    'create-state'                => 'Create State',
                    'street-1'                    => 'Street 1',
                    'street-2'                    => 'Street 2',
                    'city'                        => 'City',
                    'phone-code'                  => 'Phone Code',
                    'postal-code'                 => 'Postal Code',
                    'bank-account'                => 'Bank Account',
                    'bank-account-number'         => 'Bank Account Number',
                    'bank-account-holder-name'    => 'Bank Account Holder Name',
                    'bank'                        => 'Bank',
                    'create-bank'                 => 'Create Bank',
                    'status'                      => 'Status',
                    'send-money'                  => 'Send Money',
                    'private-email'               => 'Private Email',
                    'private-contact'             => 'Private Contact',
                    'private-phone'               => 'Private Phone',
                    'bank-account-number'         => 'Bank Account Number',
                    'bank-account-holder-name'    => 'Bank Account Holder Name',
                    'bank'                        => 'Bank',
                    'create-bank'                 => 'Create Bank',
                    'bank-account'                => 'Bank Account',
                    'bank-name'                   => 'Bank Name',
                    'bank-code'                   => 'Bank Code',
                    'bank-email'                  => 'Email',
                    'bank-phone-number'           => 'Phone Number',
                    'bank-street-1'               => 'Street 1',
                    'bank-street-2'               => 'Street 2',
                    'bank-city'                   => 'City',
                    'bank-zipcode'                => 'Zipcode',
                    'bank-country'                => 'Country',
                    'bank-state'                  => 'State',
                    'bank-country'                => 'Country',
                    'bank-state'                  => 'State',
                    'status'                      => 'Status',
                    'send-money'                  => 'Send Money',
                    'create-bank-account'         => 'Create Bank Account',
                    'bank-account'                => 'Bank Account',
                    'private-email'               => 'Private Email',
                    'private-car-plate'           => 'Private Car Plate',
                    'distance-home-to-work'       => 'Distance Home to Work',
                    'km-home-to-work'             => 'Km Home to Work',
                    'distance-unit'               => 'Distance Unit',
                    'emergency-contact'           => 'Emergency Contact',
                    'contact-name'                => 'Contact Name',
                    'contact-phone'               => 'Contact Phone',
                    'family-status'               => 'Family Status',
                    'marital-status'              => 'Marital Status',
                    'spouse-name'                 => 'Spouse Name',
                    'spouse-birthday'             => 'Spouse Birthday',
                    'number-of-children'          => 'Number of Children',
                    'education'                   => 'Education',
                    'graduated'                   => 'Graduated',
                    'bachelor'                    => 'Bachelor',
                    'master'                      => 'Master',
                    'doctor'                      => 'Doctor',
                    'other'                       => 'Other',
                    'certificate-level'           => 'Certificate Level',
                    'field-of-study'              => 'Field of Study',
                    'school'                      => 'School',
                    'country-of-birth'            => 'Country of Birth',
                    'citizenship'                 => 'Citizenship',
                    'identification-id'           => 'Identification ID',
                    'ssnid'                       => 'SSN No',
                    'sinid'                       => 'SIN No',
                    'passport-id'                 => 'Passport ID',
                    'permit-no'                   => 'Permit No',
                    'gender'                      => 'Gender',
                    'date-of-birth'               => 'Date of Birth',
                    'country-of-birth'            => 'Country of Birth',
                    'work-permit'                 => 'Work Permit',
                    'visa-no'                     => 'Visa No',
                    'work-permit-no'              => 'Work Permit No',
                    'visa-expiration-date'        => 'Visa Expiration',
                    'work-permit-expiration-date' => 'Work Permit Expiration Date',
                    'visa-number'                 => 'Visa Number',
                ],
            ],

            'settings' => [
                'title' => 'Settings',

                'fields' => [
                    'employment-status'              => 'Employment Status',
                    'active-employee'                => 'Active Employee',
                    'flexible-work-arrangement'      => 'Flexible Work Arrangement',
                    'fully-flexible-schedule'        => 'Fully Flexible Schedule',
                    'work-permit-scheduled-activity' => 'Work Permit Scheduled Activity',
                    'related-user'                   => 'Related User',
                    'create-user'                    => 'Create User',
                    'departure-reason'               => 'Departure Reason',
                    'departure-date'                 => 'Departure Date',
                    'departure-description'          => 'Departure Description',
                    'additional-information'         => 'Additional Information',
                    'primary-language'               => 'Primary Language',
                    'additional-notes'               => 'Additional Notes',
                    'notes'                          => 'Notes',
                    'attendance-point-of-sale'       => 'Attendance/Point of Sale',
                    'badge-id'                       => 'Badge ID',
                    'pin'                            => 'PIN',
                ],
            ],
        ],
    ],

    'table' => [
        'columns' => [
            'name'         => 'Name',
            'manager-name' => 'Manager',
            'company-name' => 'Company',
            'job-title'    => 'Job Title',
            'work-email'   => 'Work Email',
            'work-phone'   => 'Work Phone',
        ],

        'filters' => [
            'skills'                          => 'Skills',
            'resumes'                         => 'Resumes',
            'timezone'                        => 'Timezone',
            'job-title'                       => 'Job Title',
            'birth-date'                      => 'Birth Date',
            'work-email'                      => 'Work Email',
            'mobile-phone'                    => 'Mobile Phone',
            'work-phone'                      => 'Work Phone',
            'is-flexible'                     => 'Is Flexible',
            'is-fully-flexible'               => 'Is Fully Flexible',
            'is-active'                       => 'Is Active',
            'work-permit-scheduled-activity'  => 'Work Permit Scheduled Activity',
            'emergency-contact'               => 'Emergency Contact',
            'emergency-phone'                 => 'Emergency Phone',
            'private-phone'                   => 'Private Phone',
            'private-email'                   => 'Private Email',
            'private-car-plate'               => 'Private Car Plate',
            'distance-home-work'              => 'Distance Home Work',
            'km-home-work'                    => 'Km Home Work',
            'distance-home-work-unit'         => 'Distance Home Work Unit',
            'marital-status'                  => 'Marital Status',
            'spouse-name'                     => 'Spouse Name',
            'spouse-birthdate'                => 'Spouse Birthdate',
            'certificate'                     => 'Certificate',
            'study-field'                     => 'Study Field',
            'study-school'                    => 'Study School',
            'identification-id'               => 'Identification ID',
            'ssnid'                           => 'SSN No',
            'sinid'                           => 'SIN No',
            'passport-id'                     => 'Passport ID',
            'gender'                          => 'Gender',
            'children'                        => 'Children',
            'visa-no'                         => 'Visa No',
            'permit-no'                       => 'Permit No',
            'language'                        => 'Language',
            'additional-note'                 => 'Additional Note',
            'notes'                           => 'Notes',
            'barcode'                         => 'Barcode',
            'visa-expire'                     => 'Visa Expire',
            'work-permit-expiration-date'     => 'Work Permit Expiration Date',
            'departure-date'                  => 'Departure Date',
            'departure-description'           => 'Departure Description',
            'created-at'                      => 'Created At',
            'updated-at'                      => 'Updated At',
            'company'                         => 'Company',
            'created-by'                      => 'Created By',
            'calendar'                        => 'Calendar',
            'department'                      => 'Department',
            'job'                             => 'Job',
            'partner'                         => 'Partner',
            'leave-approvers'                 => 'Leave Approvers',
            'attendance'                      => 'Attendance',
            'work-location'                   => 'Work Location',
            'manager'                         => 'Manager',
            'coach'                           => 'Coach',
            'private-state'                   => 'Private State',
            'private-country'                 => 'Private Country',
            'country'                         => 'Country',
            'state'                           => 'State',
            'country-of-birth'                => 'Country of Birth',
            'bank-account'                    => 'Bank Account',
            'departure-reason'                => 'Departure Reason',
            'employee-type'                   => 'Employee Type',
            'tags'                            => 'Tags',
        ],

        'groups' => [
            'name'             => 'Name',
            'company'          => 'Company',
            'manager'          => 'Manager',
            'coach'            => 'Coach',
            'department'       => 'Department',
            'employment-type'  => 'Employment Type',
            'tags'             => 'Tags',
            'departure-reason' => 'Departure Reason',
            'private-state'    => 'Private State',
            'private-country'  => 'Private Country',
            'country'          => 'Country',
            'state'            => 'State',
            'created-at'       => 'Created At',
            'updated-at'       => 'Updated At',
        ],

        'actions' => [
            'restore' => [
                'notification' => [
                    'title' => 'Employee restored',
                    'body'  => 'The employee has been restored successfully.',
                ],
            ],

            'delete' => [
                'notification' => [
                    'title' => 'Employee deleted',
                    'body'  => 'The employee has been deleted successfully.',
                ],
            ],
        ],

        'bulk-actions' => [
            'delete' => [
                'notification' => [
                    'title' => 'Employees deleted',
                    'body'  => 'The employees has been deleted successfully.',
                ],
            ],

            'force-delete' => [
                'notification' => [
                    'success' => [
                        'title' => 'Employees deleted',
                        'body'  => 'The employees has been deleted successfully.',
                    ],

                    'error' => [
                        'title' => 'Employee could not be deleted',
                        'body'  => 'The employee cannot be deleted because it is currently in use.',
                    ],
                ],
            ],
        ],
    ],

    'infolist' => [
        'sections' => [
            'entries' => [
                'name'          => 'Name',
                'job-title'     => 'Job Title',
                'work-email'    => 'Work Email',
                'work-mobile'   => 'Work Mobile',
                'work-phone'    => 'Work Phone',
                'manager'       => 'Manager',
                'department'    => 'Department',
                'job-position'  => 'Job Position',
                'employee-tags' => 'Employee Tags',
                'coach'         => 'Coach',
            ],
        ],

        'tabs' => [
            'work-information' => [
                'title' => 'Work Information',

                'entries' => [
                    'location'             => 'Location',
                    'work-address'         => 'Work Address',
                    'work-location'        => 'Work Location',
                    'time-off'             => 'Time Off',
                    'attendance-manager'   => 'Attendance Manager',
                    'working-hours'        => 'Working Hours',
                    'timezone'             => 'Timezone',
                    'organization-details' => 'Organization Details',
                    'company'              => 'Company',
                    'color'                => 'Color',
                    'schedule'             => 'Schedule',
                ],
            ],

            'private-information' => [
                'title' => 'Private Information',

                'entries' => [
                    'country'                     => 'Country',
                    'state'                       => 'State',
                    'street-address'              => 'Street Address',
                    'street-address-line-2'       => 'Street Address Line 2',
                    'city'                        => 'City',
                    'post-code'                   => 'Post Code',
                    'private-contact'             => 'Private Contact',
                    'private-phone'               => 'Private Phone',
                    'private-email'               => 'Private Email',
                    'private-car-plate'           => 'Private Car Plate',
                    'distance-home-to-work'       => 'Distance Home to Work',
                    'emergency-contact'           => 'Emergency Contact',
                    'contact-name'                => 'Contact Name',
                    'contact-phone'               => 'Contact Phone',
                    'work-permit'                 => 'Work Permit',
                    'visa-number'                 => 'Visa Number',
                    'work-permit-number'          => 'Work Permit Number',
                    'visa-expiration-date'        => 'Visa Expiration Date',
                    'work-permit-expiration-date' => 'Work Permit Expiration Date',
                    'work-permit-document'        => 'Work Permit Document',
                    'citizenship'                 => 'Citizenship',
                    'identification-id'           => 'Identification ID',
                    'ssnid'                       => 'SSN No',
                    'sinid'                       => 'SIN No',
                    'passport-id'                 => 'Passport ID',
                    'gender'                      => 'Gender',
                    'date-of-birth'               => 'Date of Birth',
                    'country-of-birth'            => 'Country of Birth',
                    'phone-code'                  => 'Phone Code',

                ],
            ],

            'settings' => [
                'title' => 'Settings',

                'entries' => [
                    'employee-settings'              => 'Employee Settings',
                    'active-employee'                => 'Active Employee',
                    'flexible-work-arrangement'      => 'Flexible Work Arrangement',
                    'fully-flexible-schedule'        => 'Fully Flexible Schedule',
                    'work-permit-scheduled-activity' => 'Work Permit Scheduled Activity',
                    'related-user'                   => 'Related User',
                    'departure-reason'               => 'Departure Reason',
                    'departure-date'                 => 'Departure Date',
                    'departure-description'          => 'Departure Description',
                    'additional-information'         => 'Additional Information',
                    'primary-language'               => 'Primary Language',
                    'additional-notes'               => 'Additional Notes',
                    'notes'                          => 'Notes',
                    'attendance-point-of-sale'       => 'Attendance/Point of Sale',
                    'badge-id'                       => 'Badge ID',
                    'pin'                            => 'PIN',
                ],
            ],
        ],
    ],
];
